<?php

	// Klasa statyczna dK

	class DirectKurier
	{
		private static $apiAddress = 'http://api.directsoft.pl?wsdl'; //url prod
        //private static $apiAddress = 'http://devapi.directsoft.pl?wsdl'; //url dev

		// Rozpoznawanie kuriera i wczytywanie danych zależnych od kuriera

		public static function loadCourierData($courier, $config, $servicesArray, &$dkLicense, &$apiLoginArray, &$services, &$cod, &$listType)
		{
                    if ($courier == 'gls')
                    {
                            $dkLicense = $config->get('dk_license_gls');

                            $apiLoginArray = array
                            (
                                    'login' => $config->get('gls_login'),
                                    'password' => $config->get('gls_pass')
                            );

                            if ($services !== false)
                            {
                                    $services = $servicesArray['gls_services'];

                                    // Ustalenie wartości "cod" (za pobraniem)

                                    if(array_key_exists('cash', $services))
                                    {
                                            $cod = $services['cash'];
                                    }
                            }

                            if ($listType !== false)
                            {
                                    $listType = $config->get('gls_list_type');
                            }
                    }
                    elseif ($courier == 'ups')
                    {
                            $dkLicense = $config->get('dk_license_ups');

                            $apiLoginArray = array
                            (
                                    'client_number' => $config->get('ups_client_number'),
                                    'access_key' => $config->get('ups_access_key'),
                                    'login' => $config->get('ups_login'),
                                    'password' => $config->get('ups_pass')
                            );

                            if ($services !== false)
                            {
                                    $services = $servicesArray['ups_services'];

                                    // Ustalenie wartości "cod" (za pobraniem)

                                    if(array_key_exists('cash', $services))
                                    {
                                            $cod = $services['cash'];
                                    }
                            }

                            if ($listType !== false)
                            {
                                    $listType = $config->get('ups_list_type');
                            }
                    }
                    elseif ($courier == 'dpd')
                    {
                        $dkLicense = $config->get('dk_license_dpd');

                        $apiLoginArray = array
                        (
                            'login' => $config->get('dpd_login'),
                            'password' => $config->get('dpd_pass'),
                            'fid' => $config->get('dpd_fid')
                        );

                        if ($services !== false)
                        {
                            $services = $servicesArray['dpd_services'];

                            // Ustalenie wartości "cod" (za pobraniem)

                            if(array_key_exists('cash', $services))
                            {
                                $cod = $services['cash'];
                            }
                        }

                        if ($listType !== false)
                        {
                            $listType = $config->get('dpd_list_type');
                        }
                    }
                    elseif ($courier == 'sio')
                    {
                        $dkLicense = $config->get('dk_license_sio');

                        $apiLoginArray = array
                        (
                            'client_id' => $config->get('sio_client_id'),
                            'api_key' => $config->get('sio_api_key'),
                            'courier_key' => $config->get('sio_courier_key')
                        );

                        if ($services !== false)
                        {
                            $services = $servicesArray['sio_services'];

                            // Ustalenie wartości "cod" (za pobraniem)

                            if(array_key_exists('cash', $services))
                            {
                                $cod = $services['cash'];
                            }
                        }

                        if ($listType !== false)
                        {
                            $listType = 'pdf';
                        }
                    }
                    elseif ($courier == 'dhl')
                    {
                        $dkLicense = $config->get('dk_license_dhl');

                        $apiLoginArray = array
                        (
                            'login' => $config->get('dhl_login'),
                            'password' => $config->get('dhl_pass'),
                            'sap' => $config->get('dhl_sap'),
                            'login_point' => $config->get('dhl_point_login'),
                            'password_point' => $config->get('dhl_point_pass')
                        );

                        if ($services !== false)
                        {
                            $services = $servicesArray['dhl_services'];

                            // Ustalenie wartości "cod" (za pobraniem)

                            if(array_key_exists('cash', $services))
                            {
                                $cod = $services['cash'];
                            }
                        }

                        if ($listType !== false)
                        {
                            $listType = $config->get('dhl_list_type');
                        }
                    }
		}

		// Sprawdzenie czy licencja jest ważna i czy posiada status demo

		public static function checkLicense($dkLicense)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('checkLicense', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense()
			));

			unset($client);

			return $result;
		}

		// Generowanie licencji DEMO dK

		public static function generateLicense($courier)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('generateLicense', array
			(
				'dkVersion' => self::getDkVersion(),
				'stLicense' => self::getStLicense(),
				'courier' => $courier,
				'data' => self::getShopInfo()
			));

			unset($client);

			return $result;
		}

		// Wywoływanie własnych funkcji w API dK

		public static function customFunction($funcName, $argsArray)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('customFunction', array
			(
				'dkVersion' => self::getDkVersion(),
				'funcName' => $funcName,
				'argsArray' => $argsArray
			));

			unset($client);

			return $result;
		}

		// Pobieranie dokumentu wydania

		public static function getDeliveryNote($dkLicense, $apiLoginArray, $data)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('getDeliveryNote', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense(),
				'apiLoginArray' => $apiLoginArray,
				'data' => $data
			));

			unset($client);

			return $result;
		}

		// Ponowne pobieranie dokumentu wydania

		public static function getDeliveryNoteAgain($dkLicense, $apiLoginArray, $data)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('getDeliveryNoteAgain', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense(),
				'apiLoginArray' => $apiLoginArray,
				'data' => $data
			));

			unset($client);

			return $result;
		}

		// Usuwanie paczki

		public static function shippingDelete($dkLicense, $apiLoginArray, $data)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('shippingDelete', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense(),
				'apiLoginArray' => $apiLoginArray,
				'data' => $data
			));

			unset($client);

			return $result;
		}

		// Ponowne pobieranie listu przewozowego

		public static function getShippingListAgain($dkLicense, $apiLoginArray, $data)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('getShippingListAgain', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense(),
				'apiLoginArray' => $apiLoginArray,
				'data' => $data
			));

			unset($client);

			return $result;
		}

		// Zmiana statusów zamówień

		public static function changeOrdersStatus($orderIds, $orderStatusId)
		{
			$c = new Criteria();
			$c->add(OrderPeer::ID, $orderIds, Criteria::IN);
			$orders = OrderPeer::doSelect($c);

			foreach ($orders as $order)
			{
				$sendMail = false;

	        	if ($order->getOrderStatusId() != $orderStatusId)
	        	{
	            	$newStatus = OrderStatusPeer::retrieveByPK($orderStatusId);

	                if (is_object($newStatus) && $newStatus->getHasMailNotification())
					{
						$sendMail = true;
					}
	            }

				$order->setOrderStatusId($orderStatusId);

				$order->save();

				if ($sendMail)
				{
					self::sendOrderStatus($order);

					return true;
				}
				else
				{
					return false;
				}
			}
		}

		// Generowanie dokumentu wydania (WIP)

		public static function generateDeliveryNote($shippings)
		{
			// $html = 'WIP';

			// $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
			// $pdf->SetFont('freesans', '', 12);
			// $pdf->SetPrintHeader(false);
			// $pdf->AddPage();
			// $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
			// $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

			// return base64_encode($pdf->Output('', 'S'));
		}

		// Obsługa pobierania pojedyńczego pliku listu/dokumentu nadania

		public static function fileDownload($stream, $listType)
		{
			if ($stream == '' && $listType == '')
			{
				$stream = $_SESSION['dk_doc'];
				$listType = $_SESSION['dk_list_type'];
			}

            $fileExtension = 'pdf';

			if ($listType === 'roll_160x100_datamax')
			{
				$fileExtension = 'dpl';
			}
			elseif ($listType === 'roll_160x100_zebra')
			{
				$fileExtension = 'dpl';
			}
			elseif ($listType === 'roll_160x100_zebra_epl' || $listType === 'EPL2')
			{
				$fileExtension = 'epl';
			}
			elseif ($listType === 'gif' || $listType === 'GIF')
			{
				$fileExtension = 'gif';
			}
			elseif ($listType === 'png' || $listType === 'PNG')
			{
				$fileExtension = 'png';
			}
			elseif ($listType === 'zpl' || $listType === 'ZPL')
			{
				$fileExtension = 'zpl';
			}
			elseif ($listType === 'spl' || $listType === 'SPL')
			{
				$fileExtension = 'spl';
			}

            $fileName = 'dk_soteshop_'.date('Y_m_d_His').'.'.$fileExtension;

            sfContext::getInstance()->getResponse()->clearHttpHeaders();
            sfContext::getInstance()->getResponse()->setHttpheader('Pragma: public', true);
            sfContext::getInstance()->getResponse()->setHttpHeader('Content-Type', 'application/'.$fileExtension);
            sfContext::getInstance()->getResponse()->setHttpHeader('Content-Description', 'File Transfer');
            sfContext::getInstance()->getResponse()->setHttpHeader('Content-Disposition', 'attachment; filename="'.$fileName.'"');
            sfContext::getInstance()->getResponse()->setContent(base64_decode($stream));

			sfContext::getInstance()->getResponse()->sendHttpHeaders();
		}

		// Obliczanie wagi paczki lub pobieranie jej z domyślnej konfiguracji jeśli obliczona jest równa 0

		public static function getWeight($orderIds)
		{
			$config = stConfig::getInstance('zrDkMain');
			$weightFromConfig = $config->get('default_weight');

			if ($config->get('always_set_default_weight') != 1)
			{
				$weight = 0;

				$c = new Criteria();
				$c->add(OrderProductPeer::ORDER_ID, $orderIds, Criteria::IN);

				$orderProducts = OrderProductPeer::doSelectJoinProduct($c);

				foreach ($orderProducts as $orderProduct)
				{
					$weight += $orderProduct->getQuantity() * $orderProduct->getProduct()->getWeight();
				}

				if ($weight == 0 && $weightFromConfig != null)
				{
					$weight = $weightFromConfig;
				}
			}
			else
			{
				$weight = $weightFromConfig;
			}

			if ($weight == '')
			{
				$weight = 0;
			}

			return $weight;
		}

		// Pobieranie informacji o skleie

		public static function getShopInfo()
		{
            $config = stConfig::getInstance('zrDkMain');
			$shopInfo = stConfig::getInstance('stShopInfoBackend');
			$result = array();

			$result['sote_info_name'] = $config->get('company') ? $config->get('company') : $shopInfo->get('company');
            $result['sote_info_nip'] = $config->get('nip') ? $config->get('nip') : $shopInfo->get('nip');
            $result['sote_info_country'] = $config->get('country') ? $config->get('country') :'PL';
            $result['sote_info_code'] = $config->get('code') ? $config->get('code') : $shopInfo->get('code');
            $result['sote_info_city'] = $config->get('city') ? $config->get('city') : $shopInfo->get('town');
            $result['sote_info_bank'] = $config->get('bank') ? $config->get('bank') : $shopInfo->get('bank');

            if ($config->get('address'))
            {
                $result['sote_info_address'] = $config->get('address');
            }
            else
            {
                $result['sote_info_address'] = $shopInfo->get('street').' '.$shopInfo->get('house');

                if ($shopInfo->get('flat') != '')
                {
                    $result['sote_info_address'] .= '/'.$shopInfo->get('flat');
                }
            }

            $result['www'] = $_SERVER['HTTP_HOST'];
            $result['sote_info_phone_number'] = $config->get('phone') ? $config->get('phone') : $shopInfo->get('phone');
            $result['sote_info_email'] = $config->get('email') ? $config->get('email') : $shopInfo->get('email');
            $result['sote_info_person'] = $config->get('person') ? $config->get('person') : $shopInfo->get('person');

			return $result;
		}

		// Tworzenie klienta SOAP

		public static function createSoapClient()
		{
			$client = new SoapClient(null, array
			(
				'location' => self::$apiAddress,
				'uri' => 'http://schemas.xmlsoap.org/soap/encoding',
				'encoding' => 'UTF-8'
			));

			$client->decode_utf8 = false;

			return $client;
		}

		// Pobieranie i hashowanie licencji sklepu

		public static function getStLicense()
		{
			$stLicense = new stLicense();

			return md5($stLicense->getLicense());
		}

		// Pobieranie numeru wersji paczki dK

		public static function getDkVersion()
		{
			$pearInfo = stPearInfo::getInstance();

			return $pearInfo->getPackageVersion('appDirectKurierPlugin');
		}

		// Obsługa komunikatu błędu

		public static function getError($error, $i18n)
		{
			if ($error == '0x900001')
			{
				return $i18n->__('Brak licencji directKURIER.');
			}
			elseif ($error == '0x900003')
			{
				return $i18n->__('Licencja directKURIER jest nieaktywna.');
			}
			elseif ($error == '0x900004')
			{
				return $i18n->__('Dane dostępu do API kuriera nie zostały wypełnione.');
			}
			elseif ($error == '0x000007')
			{
				return $i18n->__('directKurier jest nieaktualny. Zaktualizuj plugin do najnowszej wersji.');
			}

			return $i18n->__($error);
		}

		// Wysyłanie maila po zmianie statusu - na podstawie stOrderActions

		protected static function sendOrderStatus($order)
		{
			$send_link = 0;

			$c = new Criteria();
			$c->add(InvoicePeer::ORDER_ID , $order->getId());
			$c->add(InvoicePeer::IS_CONFIRM , 1);
			$invoice = InvoicePeer::doSelectOne($c);

			if($invoice)
			{
				$send_link = 1;
			}

			if ($order->getOrderStatus()->getAttachCouponCode())
			{
				$order_status = $order->getOrderStatus();

				$coupon_code = new DiscountCouponCode();

				$coupon_code->setDiscount($order_status->getCouponCodeDiscount());
				$coupon_code->setValidUsage(1);
				$coupon_code->setSfGuardUserId($order->getSfGuardUserId());

				$valid_for = $order_status->getCouponCodeValidFor();

				if ($valid_for > 0)
				{
					$coupon_code->setValidFor($valid_for);
				}

				$coupon_code->save();
			}
			else
			{
				$coupon_code = null;
			}

			$mailHtmlHead = stMailer::getHtmlMailDescription("header");
			$mailHtmlFoot = stMailer::getHtmlMailDescription("footer");
			$mailHtmlHeadContent = stMailer::getHtmlMailDescription("top_order_status");
			$mailHtmlHeadContent = stEventDispatcher::getInstance()->filter(new sfEvent(self, 'stOrder.sendOrderStatus_mailHtmlHeadContent', array('order' => $order)), $mailHtmlHeadContent)->getReturnValue();
			$mailHtmlFootContent = stMailer::getHtmlMailDescription("bottom_order_status");

			$orderStatus = $order->getOrderStatus();
			$orderStatus->setCulture($order->getClientCulture());

			$mailHtmlHead = str_replace('{ORDER_STATUS}', $orderStatus, $mailHtmlHead);
			$mailHtmlFoot = str_replace('{ORDER_STATUS}', $orderStatus, $mailHtmlFoot);
			$mailHtmlHeadContent = str_replace('{ORDER_STATUS}', "<b>".$orderStatus."</b>", $mailHtmlHeadContent);
			$mailHtmlFootContent = str_replace('{ORDER_STATUS}', "<b>".$orderStatus."</b>", $mailHtmlFootContent);

			$html = stMailTemplate::render('orderStatusHtml', array
			(
				'order' => $order,
				'send_link' => $send_link,
				'coupon_code' => $coupon_code,
				'head' => $mailHtmlHead,
				'foot' => $mailHtmlFoot,
				'head_content' => $mailHtmlHeadContent,
				'foot_content' => $mailHtmlFootContent
			));

			$mailPlainHead = stMailer::getPlainMailDescription("header");
			$mailPlainFoot = stMailer::getPlainMailDescription("footer");
			$mailPlainHeadContent = stMailer::getPlainMailDescription("top_order_status");
			$mailPlainHeadContent = stEventDispatcher::getInstance()->filter(new sfEvent(self, 'stOrder.sendOrderStatus_mailPlainHeadContent', array('order' => $order)), $mailPlainHeadContent)->getReturnValue();
			$mailPlainFootContent = stMailer::getPlainMailDescription("bottom_order_status");
			$mailPlainHead = str_replace('{ORDER_STATUS}', $order->getOrderStatus(), $mailPlainHead);
			$mailPlainFoot = str_replace('{ORDER_STATUS}', $order->getOrderStatus(), $mailPlainFoot);
			$mailPlainHeadContent = str_replace('{ORDER_STATUS}', $order->getOrderStatus(), $mailPlainHeadContent);
			$mailPlainFootContent = str_replace('{ORDER_STATUS}', $order->getOrderStatus(), $mailPlainFootContent);

			$plain = stMailTemplate::render
			(
				'orderStatusPlain', array('order' => $order,
				'send_link' => $send_link,
				'coupon_code' => $coupon_code,
				'head' => $mailPlainHead,
				'foot' => $mailPlainFoot,
				'head_content' => $mailPlainHeadContent,
				'foot_content' => $mailPlainFootContent
			));

			$mail = stMailer::getInstance();

			$context = sfContext::getInstance();
			$i18n = $context->getI18N();

			if($order->getHost()!="")
			{
				$host = $order->getHost();
			}
			else
			{
				$host = $context->getRequest()->getHost();
			}

			$subject = $i18n->__('%host% - Zamówienie numer "%number%": %status%', array('%host%' => $host, '%number%' => $order->getNumber(), '%status%' => $order->getOrderStatus()));

			$c = new Criteria();
			$c->add(sfGuardUserPeer::ID, $order->getSfGuardUserId());
			$user = sfGuardUserPeer::doSelectOne($c);

			if($user)
			{
				$user_mail = $user->getUsername();
			}
			else
			{
				$user_mail = $order->getOptClientEmail();
			}

			$ret = $mail->setSubject($subject)->setHtmlMessage($html)->setPlainMessage($plain)->setTo($user_mail)->sendToClient();

			if (!$ret && $coupon_code)
			{
				$coupon_code->delete();
			}

			return $ret;
		}

                // Pobieranie dokumentu wydania

		public static function getShippingListGroup($dkLicense, $apiLoginArray, $data)
		{
			$client = self::createSoapClient();

			$result = $client->__soapCall('getShippingListGroup', array
			(
				'dkVersion' => self::getDkVersion(),
				'dkLicense' => $dkLicense,
				'stLicense' => self::getStLicense(),
				'apiLoginArray' => $apiLoginArray,
				'data' => $data
			));

			unset($client);

			return $result;
		}
	}