<?php

class DkShipping
{
	public $dkLicense;
	public $data;
	public $apiLoginArray;
	
	private $stLicense;
	private $shippingList;
	private $shippingNumber;
	private $idFromCourier;
	private $error;
	
	// Akcesory
	
	public function getStLicense()
	{
		return $this->$stLicense;
	}
	
	public function getShippingList()
	{
		return $this->shippingList;
	}
	
	public function getShippingNumber()
	{
		return $this->shippingNumber;
	}
	
	public function getIdFromCourier()
	{
		return $this->idFromCourier;
	}
	
	public function getError()
	{
		return $this->error;
	}
	
	// Konstruktor
	
	public function DkShipping()
	{
		$this->stLicense = DirectKurier::getStLicense();
		$this->client = DirectKurier::createSoapClient();
	}
	
	// Nadawanie i pobieranie przesyłki, jeśli się powiedzie zwraca true, jeśli nie to zwraca false
	
	public function sendShipping()
	{
		try
		{
			$result = $this->client->__soapCall('shippingExecute', array
			(
				'dkVersion' => DirectKurier::getDkVersion(),
				'dkLicense' => $this->dkLicense,
				'stLicense' => $this->stLicense,
				'deliveryData' => $this->data,
				'apiLoginArray' => $this->apiLoginArray
			));
		}
		catch (Exception $e)
		{
			$this->error = '0x900005   '.$e;
			
			return false;
		}
		
		if (is_object($result))
		{
		    if (!$result->shipping_number)
            {
                $this->error = '0x900008';
                
                return false;
            }
            
			$this->shippingList = $result->shipping_list;
			$this->shippingNumber = $result->shipping_number;
			$this->idFromCourier = $result->id_from_courier;
			
			return true;
		}
		else
		{
			// Zwraca błąd z funkcji shippingExecute
			
			$this->error = $result;
			
			return false;
		}
	}
}