<?php

	// Pobieranie wartości dla inputów

	function get_input_value($array, $key, $printValue = true)
	{
		if ($array != null)
		{
			if (array_key_exists($key, $array))
			{
				if ($array[$key] == 'on')
				{
					if ($printValue == true)
					{
						echo ' checked="checked" ';
					}

					return true;
				}
				elseif ($array[$key] != '')
				{
					if ($printValue == true)
					{
						echo ' value="'.$array[$key].'" ';
					}

					return true;
				}
			}
		}

		return false;
	}

	// Wyświetlanie nagłówka tabelki paczek

	function get_package_head($editable = false)
	{
		echo '<thead>';
		echo 	'<tr>';
		echo 		'<th class="dk_packages_quantity dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl" id="dk_packages_th_quantity">'.__('Sztuk').'</th>';
		echo 		'<th class="dk_packages_references dk_hide dk_gls" id="dk_packages_th_references">'.__('Referencje').'</th>';
		echo 		'<th class="dk_packages_package_type dk_hide dk_ups dk_sio dk_dhl" id="dk_packages_th_wrapping_type">'.__('Typ opakowania').'</th>';
		echo 		'<th class="dk_packages_value dk_hide dk_ups" id="dk_packages_th_value">'. __('Deklarowana wartość').' (zł)</th>';
        echo        '<th class="dk_packages_shape dk_hide dk_sio" id="dk_packages_th_shape">'.__('Kształt').'</th>';
        echo        '<th class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl" id="dk_packages_th_size_x">'.__('Długość').'</th>';
        echo        '<th class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl" id="dk_packages_th_size_y">'.__('Szerokość').'</th>';
        echo        '<th class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl" id="dk_packages_th_size_z">'.__('Wysokość').'</th>';
		echo 		'<th class="dk_packages_weight dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl" id="dk_packages_th_weight">'.__('Waga').' (kg)</th>';
		echo 		$editable == true ? '<th class="dk_packages_delete" id="dk_packages_th_delete"></th>' : '';
		echo 	'</tr>';
		echo '</thead>';
	}

	// Wyświetlanie wiersza tabelki paczek

	function get_package_row($editable, $key, $quantity, $packageType, $reference, $value, $shape, $sizes, $weight)
	{
		if ($value != '')
		{
			$value = number_format((double)$value, 2);
		}

		if ($editable == true)
		{
			echo '<tr class="dk_package_row">';
			echo 	'<td class="dk_packages_quantity dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl"><input name="dk_packages['.$key.'][quantity]" class="dk_package_row_quantity dk_input_validate" value="'.$quantity.'" /></td>';
			echo 	'<td class="dk_packages_references dk_hide dk_gls"><input name="dk_packages['.$key.'][references]" class="dk_package_row_references" value="'.$reference.'" /></td>';
			echo 	'<td class="dk_packages_package_type dk_hide dk_ups">';
			echo 		'<select name="dk_packages['.$key.'][package_type]" class="dk_package_row_package_type">';
			echo 			'<option class="dk_hide dk_ups"  value="02" ';
			echo 				$packageType == '02' ? 'selected="selected"' : '';
			echo 			'>'.__('Inne opakowanie').'</option>';
			echo 			'<option class="dk_hide dk_ups" value="30"';
			echo 				$packageType == '30' ? 'selected="selected"' : '';
			echo 			'>'.__('Paleta').'</option>';
			echo 			'<option class="dk_hide dk_ups" value="21"';
			echo 				$packageType == '21' ? 'selected="selected"' : '';
			echo 			'>'.__('UPS Express Box').'</option>';
			echo 			'<option class="dk_hide dk_ups" value="04"';
			echo 				$packageType == '04' ? 'selected="selected"' : '';
			echo 			'>'.__('UPS PAK').'</option>';
			echo 			'<option class="dk_hide dk_ups" value="03"';
			echo 				$packageType == '03' ? 'selected="selected"' : '';
			echo 			'>'.__('UPS Tube').'</option>';
			echo 			'<option class="dk_hide dk_ups" value="01"';
			echo 				$packageType == '01' ? 'selected="selected"' : '';
			echo 			'>'.__('List').'</option>';			
			echo 		'</select>';
			echo	'</td>';
			echo 	'<td class="dk_packages_package_type dk_hide dk_dhl">';
			echo 		'<select name="dk_packages['.$key.'][package_type2]" class="dk_package_row_package_type">';
			echo 			'<option class="dk_hide dk_dhl" value="PACKAGE" ';
			echo 				$packageType == 'PACKAGE' ? 'selected="selected"' : '';
			echo 			'>'.__('Paczka').'</option>';
			echo 			'<option class="dk_hide dk_dhl" value="PALLET"';
			echo 				$packageType == 'PALLET' ? 'selected="selected"' : '';
			echo 			'>'.__('Paleta').'</option>';
			echo 			'<option class="dk_hide dk_dhl" value="ENVELOPE"';
			echo 				$packageType == 'ENVELOPE' ? 'selected="selected"' : '';
			echo 			'>'.__('Koperta').'</option>';
			echo 		'</select>';
			echo	'</td>';
                       
			echo    '<td class="dk_packages_package_type_sio dk_hide dk_sio">';
            echo        '<select name="dk_packages['.$key.'][package_type_sio]" class="dk_package_row_package_type">';
            echo            '<option value="PC"';
            echo                $packageType == 'PC' ? 'selected="selected"' : '';
            echo            '>'.__('Paczka').'</option>';
            echo            '<option value="PL"';
            echo                $packageType == 'PL' ? 'selected="selected"' : '';
            echo            '>'.__('Paleta').'</option>';
            echo            '<option value="KP"';
            echo                $packageType == 'KP' ? 'selected="selected"' : '';
            echo            '>'.__('Koperta').'</option>';
            echo        '</select>';
            echo    '</td>';
			echo    '<td class="dk_packages_shape dk_hide dk_sio">';
            echo        '<select name="dk_packages['.$key.'][shape]" class="dk_package_row_shape">';
            echo            '<option value="0" ';
            echo                $shape == '0' ? 'selected="selected"' : '';
            echo            '>'.__('Standardowy').'</option>';
            echo            '<option value="1" ';
            echo                $shape == '1' ? 'selected="selected"' : '';
            echo            '>'.__('Niestandardowy').'</option>';
            echo        '</select>';
            echo    '</td>';
			echo    '<td class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl"><input name="dk_packages['.$key.'][sizes][x]" class="dk_package_row_size" value="'.$sizes['x'].'" /></td>';
            echo    '<td class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl"><input name="dk_packages['.$key.'][sizes][y]" class="dk_package_row_size" value="'.$sizes['y'].'" /></td>';
            echo    '<td class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl"><input name="dk_packages['.$key.'][sizes][z]" class="dk_package_row_size" value="'.$sizes['z'].'" /></td>';
			echo 	'<td class="dk_packages_value dk_hide dk_ups"><input name="dk_packages['.$key.'][value]" class="dk_package_row_value dk_input_validate" value="'.$value.'" /></td>';
			echo 	'<td class="dk_packages_weight dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl"><input name="dk_packages['.$key.'][weight]" class="dk_package_row_weight dk_input_validate" value="'.$weight.'" /></td>';
			echo 	'<td class="dk_packages_delete" ><div class="dk_table_delete"></div></td>';
			echo '</tr>';
		}
		else
		{
			echo '<tr class="dk_package_row">';
			echo 	'<td class="dk_packages_quantity dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl">'.$quantity.'</td>';
			echo 	'<td class="dk_packages_references dk_hide dk_gls">'.$reference.'</td>';
			echo 	'<td class="dk_packages_package_type dk_hide dk_ups">';
			echo 		$packageType == '02' ? __('Inne opakowanie') : '';
			echo 		$packageType == '30' ? __('Paleta') : '';
			echo 		$packageType == '21' ? __('UPS Express Box') : '';
			echo 		$packageType == '04' ? __('UPS PAK') : '';
			echo 		$packageType == '03' ? __('UPS Tube') : '';
			echo 		$packageType == '01' ? __('List') : '';
			echo        $packageType == 'PC' ? __('Paczka') : '';
            echo        $packageType == 'PL' ? __('Paleta') : '';
            echo        $packageType == 'KP' ? __('Koperta') : '';
			echo	'</td>';
			echo 	'<td class="dk_packages_package_type dk_hide dk_dhl">';
			echo 		$packageType == 'PACKAGE' ? __('Paczka') : '';
			echo 		$packageType == 'PALLET' ? __('Paleta') : '';
			echo 		$packageType == 'ENVELOPE' ? __('Koperta') : '';
			echo	'</td>';
			echo    '<td class="dk_packages_package_type dk_hide dk_sio">';
            echo        $packageType == 'PC' ? __('Paczka') : '';
            echo        $packageType == 'PL' ? __('Paleta') : '';
            echo        $packageType == 'KP' ? __('Koperta') : '';
            echo    '</td>';
			echo 	'<td class="dk_packages_value dk_hide dk_ups">'.$value.'</td>';
			echo    '<td class="dk_packages_shape dk_hide dk_sio">';
            echo        $shape == '0' ? __('Standardowy') : '';
            echo        $shape == '1' ? __('Niestandardowy') : '';
            echo    '</td>';
			echo    '<td class="dk_packages_size dk_dpd dk_hide dk_sio dk_dhl">'.$sizes['x'].'</td>';
            echo    '<td class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl">'.$sizes['y'].'</td>';
            echo    '<td class="dk_packages_size dk_hide dk_dpd dk_sio dk_dhl">'.$sizes['z'].'</td>';
			echo 	'<td class="dk_packages_weight dk_hide dk_gls dk_ups dk_dpd dk_sio dk_dhl">'.$weight.'</td>';
			echo '</tr>';
		}
	}