<?php

class zrDkMainActions extends autoZrDkMainActions {

    // Lista przesyłek

    public function executeList() {
        $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoZrDkMain/forward_parameters');
        $this->related_object = null;

        $this->processSort();
        $this->processFilters();
        $this->filters = $this->getUser()->getAttributeHolder()->getAll('soteshop/stAdminGenerator/zrDkMain/list/filters');
        $max_per_page = $this->getUser()->getAttribute('list.max_per_page', array(), 'soteshop/stAdminGenerator/zrDkMain/config');

        $this->pager = new stPropelPager('DirectKurierShipping', $max_per_page ? $max_per_page : 20);

        $c = new Criteria();

        if ($sort_column = $this->getUser()->getAttribute('sort', null, 'sf_admin/autoZrDkMain/sort')) {
            $sort_column = $this->translateSortColumn($sort_column);

            if ($this->getUser()->getAttribute('type', null, 'sf_admin/autoZrDkMain/sort') == 'asc') {
                $c->addAscendingOrderByColumn($sort_column);
            } else {
                $c->addDescendingOrderByColumn($sort_column);
            }
        } else {
            $c->addDescendingOrderByColumn('created_at');
        }

        $this->addFiltersCriteria($c);
        $this->pager->setCriteria($c);
        $this->pager->setPage($this->getRequestParameter('page', 1));
        $this->pager->init();
        $this->direct_kurier_shipping_action_select_options = $this->getActionSelectControlOptions();
    }

    // AJAX zapis domyślnego kuriera

    public function executeSaveDefaultCourier() {
        if ($this->getRequest()->isXmlHttpRequest()) {
            $config = stConfig::getInstance('zrDkMain');
            $config->set('default_courier', $this->getRequestParameter('default_courier'));
            $config->save();

            return sfView::NONE;
        } else {
            return sfView::NONE;
        }
    }

    // AJAX szukanie użytkownika

    public function executeSearchUserData() {
        if ($this->getRequest()->isXmlHttpRequest()) {
            $ifCompany = $this->getRequestParameter('if_company');
            $searchString = '%' . stXssSafe::cleanHtml($this->getRequestParameter('user_data_full_name'), 'UTF-8') . '%';

            $c = new Criteria();

            $c->addJoin(UserDataPeer::COUNTRIES_ID, CountriesPeer::ID, Criteria::LEFT_JOIN);
            $c->addJoin(UserDataPeer::SF_GUARD_USER_ID, sfGuardUserPeer::ID, Criteria::LEFT_JOIN);
            $c->addGroupByColumn(UserDataPeer::COUNTRIES_ID);
            $c->addGroupByColumn(UserDataPeer::FULL_NAME);
            $c->addGroupByColumn(UserDataPeer::ADDRESS);
            $c->addGroupByColumn(UserDataPeer::ADDRESS_MORE);
            $c->addGroupByColumn(UserDataPeer::STREET);
            $c->addGroupByColumn(UserDataPeer::HOUSE);
            $c->addGroupByColumn(UserDataPeer::FLAT);
            $c->addGroupByColumn(UserDataPeer::CODE);
            $c->addGroupByColumn(UserDataPeer::TOWN);
            $c->addGroupByColumn(UserDataPeer::PHONE);

            if ($ifCompany == 1) {
                $c->add(UserDataPeer::COMPANY, $searchString, Criteria::LIKE);
            } elseif ($ifCompany == 0) {
                $c->add(UserDataPeer::FULL_NAME, $searchString, Criteria::LIKE);
            }

            $this->users = UserDataPeer::doSelect($c);
        } else {
            return sfView::NONE;
        }
    }

    // Download listów przewozowych w przypadku gdy jest ich więcej niż jeden

    public function executeMultipleDocDownload() {
        $this->docsCount = count($_SESSION['dk_multiple_docs']);
        $this->config = stConfig::getInstance('zrDkMain');
        $this->config->setCulture($this->getRequestParameter('culture', stLanguage::getOptLanguage()));
        $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoZrDkMain/forward_parameters');
    }

    // Download listu przewozowego/dokumentu wydania

    public function executeDocDownload() {
        $docKey = $this->getRequestParameter('doc_key');

        if ($docKey != '') {
            $stream = $_SESSION['dk_multiple_docs'][$docKey];
        } else {
            $stream = $_SESSION['dk_doc'][0];
        }

        $listType = $_SESSION['dk_list_type'];

        if ($stream != '' && $listType != '') {
            $_SESSION['dk_doc'] = '';

            DirectKurier::fileDownload($stream, $listType);

            return sfView::NONE;
        } else {
            $this->redirect('zrDkMain/list');
        }
    }

    // Generowanie licencji dK

    public function executeGenerateLicense() {
        $i18n = $this->getContext()->getI18N();

        $courier = stXssSafe::cleanHtml($this->getRequestParameter('courier'), 'UTF-8');

        $dkLicense = DirectKurier::generateLicense($courier);

        if (is_object($dkLicense)) {
            $config = stConfig::getInstance('zrDkMain');

            if ($courier == 'gls') {
                $config->set('dk_license_gls', $dkLicense->dk_license);
            } elseif ($courier == 'ups') {
                $config->set('dk_license_ups', $dkLicense->dk_license);
            } elseif ($courier == 'dpd') {
                $config->set('dk_license_dpd', $dkLicense->dk_license);
            } elseif ($courier == 'sio') {
                $config->set('dk_license_sio', $dkLicense->dk_license);
            } elseif ($courier == 'dhl') {
                $config->set('dk_license_dhl', $dkLicense->dk_license);
            }

            $config->save();
        } else {
            $this->setFlash('warning', $i18n->__('Błąd:') . DirectKurier::getError($dkLicense, $i18n));
        }

        if ($courier == 'gls') {
            $this->redirect('zrDkMain/glsConfig');
        } elseif ($courier == 'ups') {
            $this->redirect('zrDkMain/upsConfig');
        } elseif ($courier == 'dpd') {
            $this->redirect('zrDkMain/dpdConfig');
        } elseif ($courier == 'sio') {
            $this->redirect('zrDkMain/sioConfig');
        } elseif ($courier == 'dhl') {
            $this->redirect('zrDkMain/dhlConfig');
        }
    }

    // Tworzenie przesyłki na podstawie zamówień z listy zamówień i przekierowanie na akcję newShipping

    public function executeSendFromOrder()
    {
        $glsServices = array();
        $upsServices = array();
        $dpdServices = array();
        $sioServices = array();
        $dhlServices = array();

        $i18n = $this->getContext()->getI18N();

        $ordersIds = $this->getRequestParameter('order[selected]', array($this->getRequestParameter('id')));

        if ($ordersIds != null) {
            $config = stConfig::getInstance('zrDkMain');

            // Pobieranie zamówień

            $c = new Criteria();
            $c->add(OrderPeer::ID, $ordersIds, Criteria::IN);
            $orders = OrderPeer::doSelect($c);

            // Sprawdzenie czy z któregoś z danych zamówień nie została już nadane paczki

            $c = new Criteria();
            $c->add(DirectKurierShippingHasOrderPeer::ORDER_ID, $ordersIds, Criteria::IN);
            $shippingHasOrders = DirectKurierShippingHasOrderPeer::doSelect($c);

            if (!empty($shippingHasOrders)) {
                $this->setFlash('warning', $i18n->__('Błąd: Co najmniej jedno z zamówień zostało już nadane.'));

                return $this->redirect('order');
            }

            // Sprawdzanie czy wszyskie id dostawy we wszystkich zamówieniach są takie same
            // Wczytywanie id zamówień i id adresów  do tablic

            $orderIds = array();
            $orderDeliveryIds = array();

            foreach ($orders as $key => $order) {
                $orderIds[$key] = $order->getId();
                $orderDeliveryIds[$key] = $order->getOrderUserDataDeliveryId();
            }

            $c = new Criteria();

            $c->add(OrderUserDataDeliveryPeer::ID, $orderDeliveryIds, Criteria::IN);
            $c->addJoin(OrderUserDataDeliveryPeer::COUNTRIES_ID, CountriesPeer::ID, Criteria::LEFT_JOIN);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::COUNTRY);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::FULL_NAME);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::ADDRESS);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::ADDRESS_MORE);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::STREET);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::HOUSE);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::FLAT);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::CODE);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::TOWN);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::PHONE);
            $c->addGroupByColumn(OrderUserDataDeliveryPeer::COMPANY);

            $orderDeliverys = OrderUserDataDeliveryPeer::doSelect($c);

            if (count($orderDeliverys) > 1) {
                $flash_error = $i18n->__('Nie wszystkie adresy dostaw są jednakowe. Jeśli mimo to chcesz nadać przesyłkę to sprawdź poprawność danych i kliknij "Nadaj"');
            }

            // Przypisywanie danych dostawy

            $orderDelivery = $orderDeliverys[0];
            $dkBilling = array();
            $fullNameArray = explode(' ', $orderDelivery->getFullName());

            $dkBilling['is_company'] = $orderDelivery->getCompany() ? 'on' : '';
            $dkBilling['name'] = trim($orderDelivery->getFullName() . ' ' . $orderDelivery->getCompany());
            $dkBilling['first_name'] = $fullNameArray[0];
            $dkBilling['last_name'] = array_pop($fullNameArray);
			$dkBilling['person'] = $orderDelivery->getFullName();
            $dkBilling['country'] = is_object($orderDelivery->getCountries()) ? $orderDelivery->getCountries()->getIsoA2() : 'PL';
            $dkBilling['post_code'] = $orderDelivery->getCode();
            $dkBilling['city'] = $orderDelivery->getTown();
            $dkBilling['address'] = $orderDelivery->getAddress() . $orderDelivery->getAddressMore();
            $dkBilling['phone_number'] = $orderDelivery->getPhone();
            $dkBilling['email'] = $orders[0]->getOptClientEmail();

            // Obliczanie wagi paczki

            $weight = DirectKurier::getWeight($orderIds);

            // Wczytywanie numerów zamówień (dla referencji paczki)

            $ordersCodes = array();

            foreach ($orders as $key => $order) {
                $ordersCodes[$key] = $order->getNumber();
            }

            // Wczytywanie uwag z zamówień

            if ($config->get('set_descriptions') == 1) {
                $dkDescriptions = array();
                $dkDescriptionsNumber = array();

                foreach ($orders as $key => $order) {
                    if ($order->getDescription() != '') {
                        $dkDescriptions[$key] = $order->getDescription();
                        $dkDescriptionsNumber[$key] = $order->getNumber();
                    }
                }

                if (count($dkDescriptions) > 1) {
                    foreach ($dkDescriptions as $key => $dkDescription) {
                        $dkDescriptions[$key] = $dkDescriptionsNumber[$key] . ': ' . $dkDescriptions[$key];
                    }
                }

                $dkDescriptions = implode('; ', $dkDescriptions);
            } else {
                $dkDescriptions = '';
            }

            // Sprawdzanie "cod" (za pobraniem)

            $totalValue = 0.00;
            $cashValue = 0.00;

            foreach ($orders as $key => $order)
            {
                $totalValue += $order->getUnpaidAmount();

                $c = new Criteria();

                $c->addJoin(OrderHasPaymentPeer::PAYMENT_ID, PaymentPeer::ID, Criteria::LEFT_JOIN);
                $c->addJoin(PaymentPeer::PAYMENT_TYPE_ID, PaymentTypePeer::ID, Criteria::LEFT_JOIN);
                $c->addJoin(PaymentTypePeer::ID, PaymentTypeCodPeer::PAYMENT_TYPE_ID, Criteria::LEFT_JOIN);
                $c->add(OrderHasPaymentPeer::ORDER_ID, $order->getId());
                $c->add(PaymentTypeCodPeer::ID, NULL, Criteria::NOT_EQUAL);

                $payment = OrderHasPaymentPeer::doSelectOne($c);

                if ($payment != null)
                {
                    $cashValue += $order->getUnpaidAmount();
                }
            }

            if ($cashValue > 0) {
                $glsServices['cash'] = true;
                $glsServices['cash_value'] = $cashValue;

                $upsServices['cash'] = true;
                $upsServices['cash_value'] = $cashValue;

                $dpdServices['cash'] = true;
                $dpdServices['cash_value'] = $cashValue;

                $sioServices['cash'] = true;
                $sioServices['cash_value'] = $cashValue;
                
                $dhlServices['cash'] = true;
                $dhlServices['cash_value'] = $cashValue;
            }
			
			$upsServices['reference_one'] = implode(', ', $ordersCodes);
			$dpdServices['reference_one'] = implode(', ', $ordersCodes);
			$dhlServices['content'] = implode(', ', $ordersCodes);
			$dhlServices['mpk'] = implode(', ', $ordersCodes);

            // Tworzenie paczki na podstawie zamówień (ilość zawsze wynosi 1)

            $dkPackages = array();

            $dkDateOfDelivery = '';
            $dkPackages[0]['quantity'] = 1;
            $dkPackages[0]['references'] = implode(', ', $ordersCodes);
            $dkPackages[0]['package_type'] = '';
            $dkPackages[0]['value'] = $totalValue;
            $dkPackages[0]['shape'] = '';
            $dkPackages[0]['sizes']['x'] = $config->get('default_size_x') ? $config->get('default_size_x') : 0;
            $dkPackages[0]['sizes']['y'] = $config->get('default_size_y') ? $config->get('default_size_y') : 0;
            $dkPackages[0]['sizes']['z'] = $config->get('default_size_z') ? $config->get('default_size_z') : 0;
            $dkPackages[0]['weight'] = $weight;

            // Przekazywanie parametrów do akcji newShipping

            $this->getRequest()->setParameter('dk_billing', $dkBilling);
            $this->getRequest()->setParameter('dk_date_of_delivery', $dkDateOfDelivery);
            $this->getRequest()->setParameter('dk_packages', $dkPackages);
            $this->getRequest()->setParameter('gls_services', $glsServices);
            $this->getRequest()->setParameter('ups_services', $upsServices);
            $this->getRequest()->setParameter('dpd_services', $dpdServices);
            $this->getRequest()->setParameter('sio_services', $sioServices);
            $this->getRequest()->setParameter('dhl_services', $dhlServices);
            $this->getRequest()->setParameter('dk_descriptions', $dkDescriptions);
            $this->getRequest()->setParameter('order_ids', $orderIds);

            if (isset($flash_error)) {
                $this->getRequest()->setParameter('flash_error', $flash_error);
            }

            $this->forward('zrDkMain', 'newShipping');
        } else {
            $this->forward('zrDkMain', 'list');
        }
    }

    // Akcja odpowiedzialna za wyświetlanie formularza tworzenia nowej przesyłki

    public function executeNewShipping() {
        $this->config = stConfig::getInstance('zrDkMain');
        $this->config->setCulture($this->getRequestParameter('culture', stLanguage::getOptLanguage()));
        $this->forward_parameters = $this->getUser()->getAttributeHolder()->getAll('sf_admin/autoZrDkMain/forward_parameters');

        $this->courier = $this->getRequestParameter('set_courier');
        $this->dkBilling = $this->getRequestParameter('dk_billing');
        $this->dkDateOfDelivery = $this->getRequestParameter('dk_date_of_delivery');
        $this->dkPackages = $this->getRequestParameter('dk_packages');
        $this->glsServices = $this->getRequestParameter('gls_services');
        $this->upsServices = $this->getRequestParameter('ups_services');
        $this->dpdServices = $this->getRequestParameter('dpd_services');
        $this->sioServices = $this->getRequestParameter('sio_services');
        $this->dhlServices = $this->getRequestParameter('dhl_services');
        $this->dkDescriptions = $this->getRequestParameter('dk_descriptions');
        $this->orderIds = $this->getRequestParameter('order_ids');
        $this->flashError = $this->getRequestParameter('flash_error');
    }

    // Nadawanie przesyłki

    public function executeSendShipping() {
        $i18n = $this->getContext()->getI18N();
        $config = stConfig::getInstance('zrDkMain');

        $courier = $this->getRequestParameter('set_courier');
        $dkBilling = $this->getRequestParameter('dk_billing');
        $dkDateOfDelivery = $this->getRequestParameter('dk_date_of_delivery');
        $dkPackages = $this->getRequestParameter('dk_packages');
        $glsServices = $this->getRequestParameter('gls_services');
        $upsServices = $this->getRequestParameter('ups_services');
        $dpdServices = $this->getRequestParameter('dpd_services');
        $sioServices = $this->getRequestParameter('sio_services');
        $dhlServices = $this->getRequestParameter('dhl_services');
        $dkDescriptions = $this->getRequestParameter('dk_descriptions');
        $orderIds = $this->getRequestParameter('order_ids');

        // Usuwanie przykładowego wiersza z tabeli paczek

        unset($dkPackages['key_var']);

        // Tworzenie tablicy, która będzie przekazywana bezpośrednio do API kuriera

        $dataArray = array('billing' => $dkBilling, 'date_of_delivery' => $dkDateOfDelivery, 'packages' => $dkPackages, 'services' => '', 'descriptions' => $dkDescriptions, 'options' => '');

        $dataArray['options'] = DirectKurier::getShopInfo();

        $dkLicense = '';
        $apiLoginArray = '';

        $servicesArray = array
            (
            'gls_services' => $glsServices,
            'ups_services' => $upsServices,
            'dpd_services' => $dpdServices,
            'sio_services' => $sioServices,
            'dhl_services' => $dhlServices
        );

        $cod = '';

        DirectKurier::loadCourierData($courier, $config, $servicesArray, $dkLicense, $apiLoginArray, $dataArray['services'], $cod, $dataArray['options']['list_type']);

        // Nadawanie przesyłki

        $dkShipping = new DkShipping();

        $dkShipping->dkLicense = $dkLicense;
        $dkShipping->apiLoginArray = $apiLoginArray;
        $dkShipping->data = $dataArray;

        if ($dkShipping->sendShipping() != true) {
            // Obsługa błędu - przekierowanie na newShipping i przekazanie danych dla formularza

            $flash_error = $i18n->__('Wystąpił błąd') . ': ' . DirectKurier::getError($dkShipping->getError(), $i18n);

            $this->getRequest()->setParameter('flash_error', $flash_error);
            $this->getRequest()->setParameter('set_courier', $courier);
            $this->getRequest()->setParameter('dk_billing', $dkBilling);
            $this->getRequest()->setParameter('dk_date_of_delivery', $dkDateOfDelivery);
            $this->getRequest()->setParameter('dk_packages', $dkPackages);
            $this->getRequest()->setParameter('gls_services', $glsServices);
            $this->getRequest()->setParameter('ups_services', $upsServices);
            $this->getRequest()->setParameter('dpd_services', $dpdServices);
            $this->getRequest()->setParameter('sio_services', $sioServices);
            $this->getRequest()->setParameter('dhl_services', $dhlServices);

            $this->forward('zrDkMain', 'newShipping');
        }

        // Zapisywanie paczki do bazy danych

        $shipping = new DirectKurierShipping();
        $shipping->setNrListu($dkShipping->getShippingNumber());
        $shipping->setIdFromKurier($dkShipping->getIdFromCourier());
        $shipping->setKurier($courier);
        $shipping->setName($dkBilling['name']);
        $shipping->setCountry($dkBilling['country']);
        $shipping->setPostCode($dkBilling['post_code']);
        $shipping->setCity($dkBilling['city']);
        $shipping->setAddress($dkBilling['address']);
        $shipping->setPhoneNumber($dkBilling['phone_number']);
        $shipping->setEmail($dkBilling['email']);
        $shipping->setDateOfDelivery($dkDateOfDelivery);
        $shipping->setNotes($dkDescriptions);

        $label = $dkShipping->getShippingList();

        if ($label[0] != '') {
            $shipping->setHasLabel(1);
        }

        if (isset($cod) && $cod == 'on') {
            $shipping->setCod(1);
        }

        $shipping->setUslugi($dataArray['services']);
        $shipping->setPackages($dkPackages);

        $shipping->save();

        // Zapisywanie relacji id przesyłki - id zamówienia

        if (!empty($orderIds)) {
            foreach ($orderIds as $orderId) {
                $shippingHasOrder = new DirectKurierShippingHasOrder();
                $shippingHasOrder->setDirectKurierShippingId($shipping->getId());
                $shippingHasOrder->setOrderId($orderId);

                $shippingHasOrder->save();
            }
        }

        // Zapisywanie numeru listu przewozowego do zamówień i zmiana statusu zamówień

        $c = new Criteria();
        $c->add(OrderPeer::ID, $orderIds, Criteria::IN);
        $c->addJoin(OrderPeer::ORDER_DELIVERY_ID, OrderDeliveryPeer::ID, Criteria::LEFT_JOIN);
        $orderDeliverys = OrderDeliveryPeer::doSelect($c);

        foreach ($orderDeliverys as $orderDelivery) {
            $orderDelivery->setNumber($dkShipping->getShippingNumber());
            $orderDelivery->save();
        }

        // Zmiana statusów zamówień

        if ($config->get('is_status_change_enabled') == 1) {
            DirectKurier::changeOrdersStatus($orderIds, $config->get('status_change_select'));
        }

        // Obsługa pliku listu przewozowego

        $_SESSION['dk_list_type'] = $dataArray['options']['list_type'];

        if (count($dkShipping->getShippingList()) == 1) {
            // Jeśli jeden

            $_SESSION['dk_doc'] = $dkShipping->getShippingList();

            $this->setFlash('notice', $i18n->__('Przesyłka została nadana poprawnie.'));
            $this->redirect('zrDkMain/list?dk_doc=true');
        } else {
            // Jeśli więcej niż jeden

            $_SESSION['dk_multiple_docs'] = $dkShipping->getShippingList();

            $this->forward('zrDkMain', 'multipleDocDownload');
        }
    }

    // Ponowne pobieranie listu przewozowego

    public function executeGetShippingListAgain() {
        $i18n = $this->getContext()->getI18N();
        $config = stConfig::getInstance('zrDkMain');

        // Pobieranie id przesyłki

        $shippingId = stXssSafe::cleanHtml($this->getRequestParameter('id'));

        $c = new Criteria();
        $c->add(DirectKurierShippingPeer::ID, $shippingId);

        $shipping = DirectKurierShippingPeer::doSelectOne($c);

        $courier = $shipping->getKurier();
        $idFromCourierArray = $shipping->getIdFromKurier();

        // Sprawdzenie czy dany kurier obsługuje ponowne pobranie listu przewozowego

        if ($courier !== 'gls' && $courier !== 'dpd' && $courier !== 'dhl') {
            $this->setFlash('warning', $i18n->__('Błąd: Kurier, którym nadano przesyłkę nie obsługuje możliwości ponownego pobrania listu przewozowego.'));

            return $this->redirect('zrDkMain/list');
        }

        $dkLicense = '';
        $apiLoginArray = '';
        $listType = '';
        $emptyVarRef = '';

        DirectKurier::loadCourierData($courier, $config, false, $dkLicense, $apiLoginArray, $emptyVarRef, $emptyVarRef, $listType);

        $data = array('id_from_courier' => $idFromCourierArray, 'list_type' => $listType, 'shipping_number' => $shipping->getNrListu());

        $shippingList = DirectKurier::getShippingListAgain($dkLicense, $apiLoginArray, $data);

        if (!is_object($shippingList)) {
            $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($shippingList, $i18n));

            return $this->redirect('zrDkMain/list');
        }

        DirectKurier::fileDownload($shippingList->shipping_list, $listType);

        return sfView::NONE;
    }

    // Pobieranie dokumentu wydania

    public function executeGetDeliveryNote() {
        $i18n = $this->getContext()->getI18N();

        $shippingIds = $this->getRequestParameter('direct_kurier_shipping[selected]', array($this->getRequestParameter('id')));

        if ($shippingIds != null) {
            $config = stConfig::getInstance('zrDkMain');

            // Pobieranie wybranych przesyłek

            $c = new Criteria();
			if($courier === 'dhl')
				$c->add(DirectKurierShippingPeer::DATE_OF_DELIVERY, date("Y-m-d"));
			else
            	$c->add(DirectKurierShippingPeer::ID, $shippingIds, Criteria::IN);
            $shippings = DirectKurierShippingPeer::doSelect($c);

            // Sprawdzanie czy wszystkie wybrane przesyłki pochodzą z tego samego kuriera

            $courier = $shippings[0]->getKurier();
            $country = $shippings[0]->getCountry();

            foreach ($shippings as $shipping) {
                if ($shipping->getKurier() != $courier) {
                    $this->setFlash('warning', $i18n->__('Błąd: Nie wszystkie wybrane przesyłki pochodzą z tego samego kuriera.'));

                    return $this->redirect('zrDkMain/list');
                }

                if ($shipping->getNadana() == 1) {
                    $this->setFlash('warning', $i18n->__('Błąd: Na podstawie co najmniej jednej z wybranych przesyłek dokument nadania został już utworzony.'));

                    return $this->redirect('zrDkMain/list');
                }

                if ($courier === 'dpd' && ($country === 'PL' && $shipping->getCountry() !== 'PL' || $country !== 'PL' && $shipping->getCountry() === 'PL')) {
                    $this->setFlash('warning', $i18n->__('Błąd: Wszystkie wybrane przesyłki powinne być przypisane do tego samego typu wysyłki (polska lub międzynarodowa).'));

                    return $this->redirect('zrDkMain/list');
                }
            }

            if ($courier === 'gls' || $courier === 'dpd' || $courier === 'sio' || $courier === 'dhl') {
                // Pobieranie z API

                $dkLicense = '';
                $apiLoginArray = '';
                $emptyVarRef = '';

                DirectKurier::loadCourierData($courier, $config, false, $dkLicense, $apiLoginArray, $emptyVarRef, $emptyVarRef, $emptyVarRef);

                // Pobieranie id_from_courier

                $idsFromCourier = array();

                foreach ($shippings as $key => $shipping) {
                    $idsFromCourier[$key] = $shipping->getIdFromKurier();
                }

                $data = array('id_from_courier' => $idsFromCourier, 'pl' => $country === 'PL');

                // Pobieranie dokumentu wydania

                $deliveryNote = DirectKurier::getDeliveryNote($dkLicense, $apiLoginArray, $data);

                if (!is_object($deliveryNote)) {
                    $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($deliveryNote, $i18n));

                    return $this->redirect('zrDkMain/list');
                }

                $idFromKurier = $deliveryNote->id_from_kurier;
                $deliveryNote = $deliveryNote->delivery_note;
            } else {
                // Generowanie przez dK - WIP
                //$deliveryNote = DirectKurier::generateDeliveryNote($shippings);

                $this->setFlash('notice', $i18n->__('Status "Wydana kurierowi" został nadany pomyślnie, jednak dla tego kuriera opcja pobrania dokumentu wydania jest nie dostępna.'));
                $deliveryNote = '';
                $idFromKurier = '';
            }

            // Zmiana statusu "nadana" przesyłek

            $con = Propel::getConnection();

            $whereC = new Criteria();
            $whereC->add(DirectKurierShippingPeer::ID, $shippingIds, Criteria::IN);

            $updC = new Criteria();
            $updC->add(DirectKurierShippingPeer::NADANA, 1);

            BasePeer::doUpdate($whereC, $updC, $con);

            if ($deliveryNote != '') {
                if ($courier == 'gls') {
                    // Zapis listu przewozowego do bazy

                    $deliveryNoteModel = new DeliveryNote();

                    $deliveryNoteModel->setKurier($courier);
                    $deliveryNoteModel->setIdFromKurier($idFromKurier);

                    $deliveryNoteModel->save();
                }

                // Pobranie zwróconego dokumentu nadania

                $_SESSION['dk_doc'][0] = $deliveryNote;
                $_SESSION['dk_list_type'] = 'pdf';

                $this->redirect('zrDkMain/list?dk_doc=true');
            } else {
                $this->forward('zrDkMain', 'list');
            }
        } else {
            $this->forward('zrDkMain', 'list');
        }
    }

    // Ponowne pobieranie dokumentu wydania

    public function executeGetDeliveryNoteAgain() {
        // TYLKO GLS

        $config = stConfig::getInstance('zrDkMain');

        $dkLicense = '';
        $apiLoginArray = '';
        $emptyVarRef = '';

        DirectKurier::loadCourierData('gls', $config, false, $dkLicense, $apiLoginArray, $emptyVarRef, $emptyVarRef, $emptyVarRef);

        $deliveryNoteModel = DeliveryNotePeer::retrievebyPk($this->getRequestParameter('id'));

        if (is_object($deliveryNoteModel)) {
            $data = array('id_from_courier' => $deliveryNoteModel->getIdFromKurier());

            $deliveryNote = DirectKurier::getDeliveryNoteAgain($dkLicense, $apiLoginArray, $data);

            if (!is_object($deliveryNote)) {
                $i18n = $this->getContext()->getI18N();

                $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($deliveryNote, $i18n));

                return $this->redirect('zrDkMain/deliveryNoteList');
            }

            DirectKurier::fileDownload($deliveryNote->delivery_note, 'pdf');
        }

        return sfView::NONE;
    }

    // Usuwanie dokumentu wydania

    public function executeDeliveryNoteDelete() {
        $deliveryNotesIds = $this->getRequestParameter('delivery_note[selected]', array($this->getRequestParameter('id')));

        $c = new Criteria();
        $c->add(DeliveryNotePeer::ID, $deliveryNotesIds, Criteria::IN);
        $deliveryNotes = DeliveryNotePeer::doSelect($c);

        foreach ($deliveryNotes as $deliveryNote) {
            if ($deliveryNote->getKurier() == 'ups') {
                unlink(sfConfig::get('sf_upload_dir') . '/zrDirectKurierPlugin/deliveryNotes/' . $deliveryNote->getFilename);
            }
        }

        parent::executeDeliveryNoteDelete();
    }

    // Usuwanie przesyłki w API kuriera i w bazie dK

    public function executeDelete() {
        $shippingIds = '';
        $deleteShippingInApi = false;
        $dkLicense = '';
        $apiLoginArray = '';
        $data = array();
        $deletedCount = 0;

        $i18n = $this->getContext()->getI18N();
        $config = stConfig::getInstance('zrDkMain');

        $shippingIds = $this->getRequestParameter('direct_kurier_shipping[selected]', array($this->getRequestParameter('id')));

        if (empty($shippingIds)) {
            return sfView::NONE;
        }

        // Pobieranie przesyłki

        $c = new Criteria();

        $c->add(DirectKurierShippingPeer::ID, $shippingIds, Criteria::IN);
        $shippings = DirectKurierShippingPeer::doSelect($c);

        foreach ($shippings as $key => $shipping) {
            if ($shipping->getNadana() != 1) {
                if ($shipping->getKurier() == 'gls') {
                    $deleteShippingInApi = true;

                    $dkLicense = $config->get('dk_license_gls');

                    $apiLoginArray = array
                        (
                        'login' => $config->get('gls_login'),
                        'password' => $config->get('gls_pass')
                    );

                    $data['id_from_courier'] = $shipping->getIdFromKurier();
                }

                if ($deleteShippingInApi == true) {
                    // Usuwanie paczki u kuriera

                    $deleteState = DirectKurier::shippingDelete($dkLicense, $apiLoginArray, $data);

                    if (!is_object($deleteState)) {
                        // Obsługa błędu zwracanego z API

                        $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($deleteState, $i18n));

                        return $this->redirect('zrDkMain/list');
                    }
                }

                // Usuwanie przesyłek w bazie

                $c = new Criteria();

                $c->add(DirectKurierShippingPeer::ID, $shipping->getId());

                DirectKurierShippingPeer::doDelete($c);

                // Usuwanie powiązań z zamówieniami w bazie

                $c = new Criteria();

                $c->add(DirectKurierShippingHasOrderPeer::DIRECT_KURIER_SHIPPING_ID, $shipping->getId());

                DirectKurierShippingHasOrderPeer::doDelete($c);

                $deletedCount++;
            }
        }

        if ($deletedCount === 0) {
            $this->setFlash('warning', $i18n->__('Błąd: Nie można usunąć nadanych przesyłek.'));
        } else {
            $this->setFlash('notice', $i18n->__('Nienadane przesyłki zostały pomyślnie usunięte.'));
        }

        return $this->redirect('zrDkMain/list');
    }

    public function executeGetShippingListGroup()
    {
        $i18n = $this->getContext()->getI18N();

        $shippingIds = $this->getRequestParameter('direct_kurier_shipping[selected]', array($this->getRequestParameter('id')));

        if ($shippingIds != null) {
            $config = stConfig::getInstance('zrDkMain');

            // Pobieranie wybranych przesyłek

            $c = new Criteria();
            $c->add(DirectKurierShippingPeer::ID, $shippingIds, Criteria::IN);
            $shippings = DirectKurierShippingPeer::doSelect($c);

            // Sprawdzanie czy wszystkie wybrane przesyłki pochodzą z tego samego kuriera

            $courier = $shippings[0]->getKurier();
            $country = $shippings[0]->getCountry();

            foreach ($shippings as $shipping) {
                if ($shipping->getKurier() != $courier) {
                    $this->setFlash('warning', $i18n->__('Błąd: Nie wszystkie wybrane przesyłki pochodzą z tego samego kuriera.'));

                    return $this->redirect('zrDkMain/list');
                }

                if ($shipping->getNadana() == 1) {
                    $this->setFlash('warning', $i18n->__('Błąd: Dla co najmniej jednej z wybranych przesyłek dokument nadania został już utworzony.'));

                    return $this->redirect('zrDkMain/list');
                }

                if ($courier === 'dpd' && ($country === 'PL' && $shipping->getCountry() !== 'PL' || $country !== 'PL' && $shipping->getCountry() === 'PL')) {
                    $this->setFlash('warning', $i18n->__('Błąd: Wszystkie wybrane przesyłki powinne być przypisane do tego samego typu wysyłki (polska lub międzynarodowa).'));

                    return $this->redirect('zrDkMain/list');
                }
            }

            if ($courier === 'dpd') {
                // Pobieranie z API

                $dkLicense = '';
                $apiLoginArray = '';
                $emptyVarRef = '';

                DirectKurier::loadCourierData($courier, $config, false, $dkLicense, $apiLoginArray, $emptyVarRef, $emptyVarRef, $listType);

                // Pobieranie id_from_courier

                $idsFromCourier = array();
				$numberList = array();

                foreach ($shippings as $key => $shipping) {
                    $idsFromCourier[$key] = $shipping->getIdFromKurier();
					$numberList[$key] = $shipping->getNrListu();
                }

                $data = array('id_from_courier' => $idsFromCourier, 'number_list' => $numberList, 'pl' => $country === 'PL', 'list_type'=>$listType);

                // Pobieranie grupowe etykiet
                $deliveryLabels = DirectKurier::getShippingListGroup($dkLicense, $apiLoginArray, $data);

                if (!is_object($deliveryLabels)) {
                    $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($deliveryLabels, $i18n));

                    return $this->redirect('zrDkMain/list');
                }

                $deliveryLabels = $deliveryLabels;
            } else {
                // Generowanie przez dK - WIP
                //$deliveryNote = DirectKurier::generateDeliveryNote($shippings);

                $this->setFlash('notice', $i18n->__('Dla tego kuriera opcja grupowego pobrania listów przewozowych jest nie dostępne.'));
                $deliveryLabels = '';
            }

			if (!is_object($deliveryLabels)) {
                $i18n = $this->getContext()->getI18N();

                $this->setFlash('warning', $i18n->__('Błąd') . ': ' . DirectKurier::getError($deliveryLabels, $i18n));

                return $this->redirect('zrDkMain/list');
            }

            DirectKurier::fileDownload($deliveryLabels->shipping_list, $listType);
            return sfView::NONE;
        } else {
            $this->forward('zrDkMain', 'list');
        }
    }
}
