<?php

    $defaultSizes['x']  = $config->get('default_size_x') ? $config->get('default_size_x') : 0;
    $defaultSizes['y']  = $config->get('default_size_y') ? $config->get('default_size_y') : 0;
    $defaultSizes['z']  = $config->get('default_size_z') ? $config->get('default_size_z') : 0;

?>

<!-- Przykładowy ukryty wiersz tabeli paczek dla javaScript -->

<table id="dk_packages_sample_row" style="display: none;">
    <tbody>
        <?php get_package_row(true, 'key_var', 1, null, '', $config->get('default_value'), 0, $defaultSizes, $defaultWeight) ?>
    </tbody>
</table>
<fieldset id="packages_fieldset">
    <h2><?php echo __('Paczki'); ?></h2>
    <div class="content" id="sf_fieldset_dk_packages_slide">
        <div class="row row_date_of_delivery dk_hide dk_gls dk_dpd dk_sio dk_dhl">
            <label for="dk_packages_date_of_delivery">
                <?php echo __('Data nadania'); ?>:
            </label>
            <div class="field">
                <?php

                    $date = $dkDateOfDelivery != '' ? $dkDateOfDelivery : date('Y-m-d');
                    echo input_date_tag('dk_date_of_delivery', $date, 'rich=true');

                ?>
                <div class="clr"></div>
            </div>
        </div>
        <div class="row row_packages">
            <label>
                <?php echo __('Lista paczek'); ?>:
            </label>
            <div class="field">
                <table id="dk_packages_table" cellpadding="0" cellspacing="0">
                    <thead>
                        <?php get_package_head(true); ?>
                    </thead>
                    <tbody>
                        <?php

                            // Obsługa tabeli paczek

                            if ($dkPackages)
                            {
                                foreach ($dkPackages as $key => $dkPackage)
                                {
                                    get_package_row(true, $key, $dkPackage['quantity'], $dkPackage['package_type'], $dkPackage['references'], $dkPackage['value'], $dkPackage['shape'], $dkPackage['sizes'], $dkPackage['weight']);
                                }
                            }
                            else
                            {
                                get_package_row(true, 0, 1, null, '', $config->get('default_value'), 0, $defaultSizes, $defaultWeight);
                            }

                        ?>
                    </tbody>
                </table>
                <div class="dk_button" id="dk_table_add"><?php echo __('Dodaj'); ?><img src="/images/backend/icons/add.png" /></div>
                <div class="clr"></div>
                <div id="dk_package_error" class="form-error-msg"><?php echo __('Dodaj przynajmniej jedną paczkę'); ?></div>
            <div class="clr"></div>
          </div>
        </div>
    </div>
</fieldset>