<?php

	use_helper('DirectKurier');

	$totalQuantity = 0;
	$totalWeight = 0;

?>

<table id="dk_packages_table" cellpadding="0" cellspacing="0">
	<thead>
		<?php

			get_package_head();

		?>
	</thead>
	<tbody>
		<?php

			foreach ($direct_kurier_shipping->getPackages() as $package)
			{
                get_package_row(false, '', $package['quantity'], $package['package_type'], $package['references'], $package['value'], $package['shape'], $package['sizes'], $package['weight']);

				$totalQuantity += $package['quantity'];
				$totalWeight += $package['weight'];
			}

		?>
	</tbody>
</table>
<br />
<span>
	<?php echo __('Łączna ilość').': '.$totalQuantity; ?>
</span>
<br />
<span>
	<?php echo __('Łączna waga').': '.number_format((double) $totalWeight, 2); ?> kg
</span>

<script type="text/javascript">
	jQuery(function($)
	{
    	$(document).ready(function()
    	{
    		// Ukrywanie kolumn, które nie są potrzebne dla danego kuriera

    		var courier = '<?php echo $direct_kurier_shipping->getKurier(); ?>';

        	$('.dk_hide').hide();
			$('.dk_' + courier).show();
        });
	});
</script>