<?php

	use_helper('Object', 'Validation', 'ObjectAdmin', 'I18N', 'Date', 'VisualEffect', 'stAdminGenerator', 'DirectKurier');
	$culture = $config->getCulture();

	// Tytuł strony

	$orderIdsString = '';

	if (isset($orderIds))
	{
		if (count($orderIds) > 1)
		{
			$title = __('Stwórz przesyłkę na podstawie zamówień nr').': '.implode(', ', $orderIds);
		}
		else
		{
			$title = __('Stwórz przesyłkę na podstawie zamówienia nr').' '.$orderIds[0];
		}

        $orderIdsString = implode(', ', $orderIds);
	}
	else
	{
		$title = __('Stwórz przesyłkę');
	}

	echo st_get_admin_head(array
	(
		'@zrDirectKurierPlugin',
		'directKURIER',
		'/images/backend/main/icons/appDirectKurierPlugin.png'),
		$title,
		array('shortcuts' => array('stConfigurationPlugin')
	));

	st_include_component('zrDkMain', 'listMenu', array('forward_parameters' => $forward_parameters, 'direct_kurier_shipping' => null));

	// Wyświetlenie komunikatu błędu

	if ($flashError != '')
	{
		echo '<div id="dk_warning" class="form-errors">';
	}
	else
	{
		echo '<div id="dk_warning" class="form-errors" style="display: none;">';
	}

	echo 	'<h2>'.__('Błąd').'</h2>';
	echo 	'<dl>';
	echo 		'<dd>'.$flashError.'</dd>';
	echo 	'</dl>';
	echo '</div>';

	echo '<span id="dk_validate_warning" style="display: none;">'.__('Uzupełnij brakujące pola.').'</span>';

	// Pobieranie domyślnej wagi paczki i przekazywanie jej do javaScript

	$defaultWeight = 0;
	$defaultWeightConfig = $config->get('default_weight');

	if ($config->get('always_set_default_weight') == 1)
	{
		if ($defaultWeightConfig != '')
		{
			$defaultWeight = $defaultWeightConfig;
		}
	}

	echo '<script type="text/javascript">';
	echo 'var defaultWeight = '.$defaultWeight.';';
	echo '</script>';

	// Pobieranie informacji o sklepie

	$soteInfo = DirectKurier::getShopInfo();
	// Formularz
        
	echo form_tag('directKURIER/sendShipping', array
	(
		'id'        => 'dk_new_shipping_form',
		'class'     => 'admin_form',
		'multipart' => true,
	));
	// Przekazywanie id zamówień (dla akcji sendShipping)

	if (isset($orderIds))
	{
		foreach ($orderIds as $key => $orderId)
		{
			echo '<input type="hidden" name="order_ids['.$key.']" value="'.$orderId.'" />';
		}
	}

	// Pobieranie domyślnego kuriera lub pobieranie wcześniej wybranego (np. w przypadku wystąpienia błędu)

	if (!isset($courier) || $courier == '')
	{
		$courier = $config->get('default_courier');
	}

?>

	<!-- Wybór kuriera -->
        
	<fieldset id="shipping_company_fieldset">
		<h2><?php echo __('Wybór kuriera'); ?></h2>
		<div class="content" id="sf_fieldset_set_courier_slide">
			<div class="row row_set_courier">
				<label for="create_set_courier">
					<?php echo __('Kurier'); ?>:
				</label>
				<div class="field">
					<select name="set_courier" id="create_set_courier">
						<option value="gls" <?php echo $courier == 'gls' ? 'selected="selected"' : ''; ?> >GLS</option>
						<option value="ups" <?php echo $courier == 'ups' ? 'selected="selected"' : ''; ?> >UPS</option>
						<option value="dpd" <?php echo $courier == 'dpd' ? 'selected="selected"' : ''; ?> >DPD</option>
						<option value="dhl" <?php echo $courier == 'dhl' ? 'selected="selected"' : ''; ?> >DHL</option>
					</select>
					<div id="dk_save_default_courier_button" class="dk_button"><?php echo __('Zapisz domyślnego kuriera'); ?></div>
					<img id="dk_courier_indicator" style="display: none; float: left; width: 21px;" src="/images/backend/beta/gadgets/preloader/26x26.gif" />
					<img id="dk_courier_tick" style="display: none; float: left; width: 21px;" src="/sf/sf_admin/images/tick.png" />
			 		<div class="clr"></div>
				</div>
			</div>
		</div>
	</fieldset>

	<!-- Dane odbiorcy -->

	<?php st_include_partial('billing_form', array('dkBilling' => $dkBilling)); ?>

	<!-- Lista paczek -->

	<?php st_include_partial('lista_paczek', array('dkPackages' => $dkPackages, 'config' => $config, 'defaultWeight' => $defaultWeight, 'dkDateOfDelivery' => $dkDateOfDelivery)); ?>

	<!-- Usługi -->

	<?php st_include_partial('uslugi_gls', array('services' => $glsServices, 'soteInfo' => $soteInfo)); ?>
	<?php st_include_partial('uslugi_ups', array('services' => $upsServices, 'config' => $config)); ?>
	<?php st_include_partial('uslugi_dpd', array('services' => $dpdServices, 'config' => $config, 'defaultWeight' => $defaultWeight)); ?>
        <?php st_include_partial('uslugi_dhl', array('services' => $dhlServices, 'config' => $config)); ?>

	<!-- Uwagi -->

	<fieldset class="dk_hide dk_gls dk_ups dk_sio dk_dhl" id="notes_fieldset">
		<h2><?php echo __('Uwagi'); ?></h2>
		<div class="content">
			<div class="row row_dk_descriptions">
				<label for="dk_descriptions">
					<?php echo __('Uwagi'); ?>:
				</label>
				<div class="field">
					<textarea id="dk_descriptions" name="dk_descriptions"><?php echo $dkDescriptions; ?></textarea>
			 		<div class="clr"></div>
				</div>
			</div>
		</div>
	</fieldset>
        

	<?php
                stEventDispatcher::getInstance()->notify(new sfEvent($this, 'zrDkMain.showNew', array('param' => 'test')));
                
		echo st_get_admin_actions_head();
		echo st_get_admin_action('sendPackage', __('Nadaj'));
	    echo st_get_admin_actions_foot();

	?>

</form>

<br class="st_clear_all">

<?php

	echo st_get_admin_foot();

?>