jQuery(function($) {
	
	// Wybór kuriera - pokazywanie odpowiednich formularzy usług i kolumn tabelki paczek
	
	var courier;
	
	$(document).ready(function() {
		
		setFormCourier($('#create_set_courier').val());
		
	});
	
	$('#create_set_courier').change(function() {
		
		setFormCourier($(this).val());
		
	});
	
	function setFormCourier(courier) {
				
		$('.dk_hide').hide();
		$('.dk_' + courier).show();
		
	}
	
	// Tabela paczek - dodawanie wiersza do tabelki
	
	$('#dk_table_add').click(function() {
		
		if ($('.dk_package_row').length) {
			
			var key = $('.dk_package_row').last().children('td').children('.dk_packages_quantity input').attr('name');
			key = key.replace('dk_packages[', '');
			key = key.replace('][quantity]', '');
			key++;
			
		}
		else {
			key = 0;
		}
		
		var rowHtml = $('#dk_packages_sample_row tbody').html();
		rowHtml = rowHtml.replace(/key_var/g, key);
		
		$('#dk_packages_table tbody').append(rowHtml);
		
		setFormCourier($('#create_set_courier').val());
		
	});
	
	// Usuwanie paczki z tabelki
	
	$('.dk_table_delete').live('click', function() {
		
		$(this).parent().parent().remove();
		
	});
	
	// Zapis domyślnego kuriera
	
	$('#dk_save_default_courier_button').click(function() {
		
		var courier = $('#create_set_courier').val();		
		new Ajax.Updater(
				'',
				'/backend.php/directKURIER/saveDefaultCourier?default_courier=' + courier,
				{asynchronous:true,
					evalScripts:false,
					onComplete:function(request, json) {
						Element.hide('dk_courier_indicator');
						Element.show('dk_courier_tick');
					},
					onLoading:function(request, json) {
						Element.show('dk_courier_indicator');
						Element.hide('dk_courier_tick');
					}
				});
	
	});
	
	// Obsługa pokazywania dodatkowych pól usług
	
	$('.dk_additional_config_checkbox:checked').next('div').show();
	
	$('.dk_additional_config_checkbox').change(function() {
		
		if ($(this).prop('checked')) {
			$(this).next('div').fadeIn();
		}
		else {
			$(this).next('div').fadeOut();
		}
		
	});
	
	// Obsługa wyszukiwarki userów
	
	$('#dk_user_select_button').click(function() {
		
		$('#dk_user_select_bg, #dk_user_select_container').show();
		$('#dk_user_search').val('').focus();
		
	});

	// Kliknięcie Enter
		
	$('#dk_user_search, #dk_user_search_by_name, #dk_user_search_by_company').on('keypress', function(event) {
    	
    	if(event.which == '13'){
			
			event.preventDefault();
        	userAjaxSearch($('#dk_user_search').val());

     	}
     
  	});
  	
  	$('#dk_user_search').keyup(function() {
  	
	  	if ($('#dk_user_search').val().length > 2)
	  		$('#dk_user_search_button').removeClass('dk_button_disabled');
	  	else
			$('#dk_user_search_button').addClass('dk_button_disabled');
			
	});
	
	$('#dk_user_search_button').click(function() {
		
		userAjaxSearch($('#dk_user_search').val());
		
	});
	
	function userAjaxSearch(string) {
		
		if ($('#dk_user_search').val().length > 2) {
			
			if ($('#dk_user_search_by_name').is(':checked')) {
				var ifCompany = 0;
			}
			else if ($('#dk_user_search_by_company').is(':checked')) {
				var ifCompany = 1;
			}
			
			new Ajax.Updater('dk_user_select_data',
					'/backend.php/directKURIER/searchUserData?if_company=' + ifCompany + '&user_data_full_name=' + string,
					{asynchronous:true, evalScripts:false,
						onComplete:function(request, json) {
							Element.hide('dk_indicator');
						},
						onLoading:function(request, json) {
							Element.show('dk_indicator');
						}
					});
				
		}
		
	}
	
	// Kliknięcie Wybierz
	
	$('.dk_user_data_ok').live('click', function() {
		
		var row = $(this).parent().parent();
		
		var fullName = row.children('.dk_user_data_full_name').html();
		var firstName = row.children('.dk_user_data_first_name').html();
		var lastName = row.children('.dk_user_data_last_name').html();
		var country = row.children('.dk_user_data_country').html();
		var postCode = row.children('.dk_user_data_code').html();
		var city = row.children('.dk_user_data_town').html();
		var address = row.children('.dk_user_data_address').html();
		var phone = row.children('.dk_user_data_phone').html();
		var email = row.children('.dk_user_data_email').html();
		
		$('#dk_user_select_bg, #dk_user_select_container').hide();
		
		$('#dk_billing_name').val(fullName);
		$('#dk_billing_first_name').val(firstName);
		$('#dk_billing_last_name').val(lastName);
		$('#dk_billing_country').val(country);
		$('#dk_billing_post_code').val(postCode);
		$('#dk_billing_city').val(city);
		$('#dk_billing_address').val(address);
		$('#dk_billing_phone_number').val(phone);
		$('#dk_billing_email').val(email);
		
		if (lastName != '')
			$('#sf_fieldset_dk_billing_slide > .row > .field > input').addClass('dk_billing_user_set');
		else
			$('#sf_fieldset_dk_billing_slide > .row > .field > input').not('#dk_billing_last_name').addClass('dk_billing_user_set');
	
	});
	
	// Kliknięcie Anuluj
	
	$('#dk_user_select_button_exit').click(function() {
		$('#dk_user_select_bg, #dk_user_select_container').hide();
	});
	
	// Wykluczanie usług GLS
	
	$('#gls_services_cash').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_exworks').change(function() {
		if (this.checked) {
			$('#gls_services_exchange').attr('checked', false).next('div').hide();
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_documentreturn').change(function() {
		if (this.checked) {
			$('#gls_services_exchange').attr('checked', false).next('div').hide();
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_exchange').change(function() {
		if (this.checked) {
			$('#gls_services_exworks').attr('checked', false);
			$('#gls_services_documentreturn').attr('checked', false);
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_deliveryatwork').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_pickandship').change(function() {
		if (this.checked) {
			$('#gls_services_cash').attr('checked', false).next('div').hide();
			$('#gls_services_exworks').attr('checked', false);
			$('#gls_services_documentreturn').attr('checked', false);
			$('#gls_services_exchange').attr('checked', false).next('div').hide();
			$('#gls_services_deliveryatwork').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
			$('#gls_services_to_ten').attr('checked', false);
			$('#gls_services_to_twelve').attr('checked', false);
			$('#gls_services_saturday').attr('checked', false);
			$('#gls_services_obior_wlasny').attr('checked', false);
		}
	});
	
	$('#gls_services_pickandreturn').change(function() {
		if (this.checked) {
			$('#gls_services_cash').attr('checked', false).next('div').hide();
			$('#gls_services_exworks').attr('checked', false);
			$('#gls_services_documentreturn').attr('checked', false);
			$('#gls_services_exchange').attr('checked', false).next('div').hide();
			$('#gls_services_deliveryatwork').attr('checked', false).next('div').hide();
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_to_ten').attr('checked', false);
			$('#gls_services_to_twelve').attr('checked', false);
			$('#gls_services_saturday').attr('checked', false);
			$('#gls_services_obior_wlasny').attr('checked', false);
		}
	});
	
	$('#gls_services_to_ten').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
			$('#gls_services_to_twelve').attr('checked', false);
		}
	});
	
	$('#gls_services_to_twelve').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
			$('#gls_services_to_ten').attr('checked', false);
		}
	});
	
	$('#gls_services_saturday').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	$('#gls_services_obior_wlasny').change(function() {
		if (this.checked) {
			$('#gls_services_pickandship').attr('checked', false).next('div').hide();
			$('#gls_services_pickandreturn').attr('checked', false);
		}
	});
	
	// Wysłanie formy
	
	$('.action-sendPackage input').click(function(event) {
		
		$(this).prop('disabled', true);
		
		event.preventDefault();
		
		// Walidacja danych odbiorcy
		
		var valid = true;
		
		$('.dk_input_validate:visible').each(function() {
			
			if ($(this).val() == '') {
				
				$(this).addClass('dk_input_not_valid');
				$(this).siblings('.form-error-msg').fadeIn();
				valid = false;
				
			}
			
		});
		
		// Walidacja - sprawdzenie czy brakuje jakiejkolwiek paczki
		
		if ($('#dk_packages_table .dk_package_row').length > 0) { } else {
			
			valid = false;
			$('#dk_package_error').show();
		
		}
		
		if (valid == false) {
		
			$('#dk_warning dd').html($('#dk_validate_warning').html());
			$('#dk_warning').show();
			window.scrollTo(0, 0);
			$(this).prop('disabled', false);
			return false;
		
		}
		
		$('#dk_new_shipping_form').submit();
		
	});
	
});